/// <reference types="node" />
import { IModLoaderAPI, ICore } from 'modloader64_api/IModLoaderAPI';
import { IRomHeader } from 'modloader64_api/IRomHeader';
import IMemory from 'modloader64_api/IMemory';
import * as API from 'modloader64_api/BK/Imports';
export declare class GameFlags extends API.BufferObj implements API.IBuffered {
    constructor(emu: IMemory);
}
export declare class HoneyCombFlags extends API.BufferObj implements API.IBuffered {
    constructor(emu: IMemory);
}
export declare class JiggyFlags extends API.BufferObj implements API.IBuffered {
    constructor(emu: IMemory);
}
export declare class MumboTokenFlags extends API.BufferObj implements API.IBuffered {
    constructor(emu: IMemory);
}
export declare class NoteTotalBuffer extends API.BufferObj implements API.IBuffered {
    constructor(emu: IMemory);
}
export declare class CurrentLevel extends API.BaseObj implements API.ICurrentLevel {
    private id_addr;
    private acorn_addr;
    private caterpillar_addr;
    private gold_bullions_addr;
    private jinjos_addr;
    private notes_addr;
    private present_green_addr;
    private present_blue_addr;
    private present_red_addr;
    private orange_addr;
    id: API.LevelType;
    acorn: number;
    caterpillar: number;
    gold_bullions: number;
    jinjos: number;
    notes: number;
    present_green: number;
    present_blue: number;
    present_red: number;
    orange: number;
}
export declare class Inventory extends API.BaseObj implements API.IInventory {
    private eggs_addr;
    private feathers_red_addr;
    private feathers_gold_addr;
    private health_upgrade_addr;
    private honeycombs_addr;
    private jiggies_addr;
    private mumbo_tokens_addr;
    private text_jiggies_addr;
    private text_mumbo_tokens_addr;
    eggs: number;
    red_feathers: number;
    gold_feathers: number;
    health_upgrades: number;
    honeycombs: number;
    jiggies: number;
    mumbo_tokens: number;
}
export declare class Player extends API.BaseObj implements API.IPlayer {
    private animal_addr;
    private anim_addr;
    private flip_facing_addr;
    private model_index_addr;
    private model_ptr_addr;
    private movement_state_addr;
    private opacity_addr;
    private pos_x_addr;
    private pos_y_addr;
    private pos_z_addr;
    private rot_x_addr;
    private rot_y_addr;
    private rot_z_addr;
    private scale_addr;
    private visible_addr;
    animal: API.AnimalType;
    animation: Buffer;
    anim_frame: number;
    anim_id: number;
    flip_facing: boolean;
    model_index: number;
    model_ptr: number;
    movement_state: number;
    opacity: number;
    position: Buffer;
    pos_x: number;
    pos_y: number;
    pos_z: number;
    rotation: Buffer;
    rot_x: number;
    rot_y: number;
    rot_z: number;
    scale: number;
    visible: boolean;
}
export declare class Runtime extends API.BaseObj implements API.IRuntime {
    private cur_events_level_addr;
    private cur_events_scene_addr;
    private cur_exit_addr;
    private cur_health_addr;
    private cur_profile_addr;
    private cur_scene_addr;
    private is_cutscene_addr;
    private is_loading_addr;
    private transition_state_addr;
    current_level: API.ICurrentLevel;
    constructor(emu: IMemory);
    current_exit: API.ExitType;
    current_health: number;
    current_level_events: number;
    current_scene: API.SceneType;
    current_scene_events: number;
    get_current_profile(): API.ProfileType;
    is_cutscene(): boolean;
    is_loading(): boolean;
    get_transition_state(): number;
    goto_scene(scene: API.SceneType, exit: API.ExitType): void;
}
export declare class SaveContext extends API.BaseObj implements API.ISaveContext {
    private move_addr;
    inventory: API.IInventory;
    game_flags: API.IBuffered;
    honeycomb_flags: API.IBuffered;
    jiggy_flags: API.IBuffered;
    mumbo_token_flags: API.IBuffered;
    note_totals: API.IBuffered;
    constructor(emu: IMemory);
    moves: number;
}
export declare class BanjoKazooie implements ICore, API.IBKCore {
    header: string;
    ModLoader: IModLoaderAPI;
    eventTicks: Map<string, Function>;
    rom_header: IRomHeader;
    player: API.IPlayer;
    runtime: API.IRuntime;
    save: API.ISaveContext;
    version: API.GameVersion;
    isPlaying(): boolean;
    preinit(): void;
    init(): void;
    postinit(): void;
    onTick(): void;
    onModLoader_RomHeaderParsed(header: Buffer): void;
    onCore_InjectFinished(evt: any): void;
}
export default BanjoKazooie;
