"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const N64Header_1 = require("./N64Header");
const Mupen_1 = require("../../monkeypatches/Mupen");
class N64 {
    constructor(rom, logger) {
        this.logger = logger;
        this.mupen = require(process.cwd() +
            '/emulator/mupen64plus.node');
        let patch = new Mupen_1.MonkeyPatch_rdramWriteBit8(this.mupen);
        //patch.patch();
        this.mupen.setConfigDir(process.cwd() + '/emulator/');
        this.mupen.setDataDir(process.cwd() + '/emulator/');
        this.mupen.setPluginDir(process.cwd() + '/emulator/');
        let code = this.mupen.initialize();
        if (code > 0) {
            this.logger.error('MUPEN INITIALIZE RETURNED ' + code.toString() + '.');
        }
        this.rom_size = this.mupen.loadRom(rom);
        if (this.rom_size < 0) {
            this.logger.error('MUPEN LOADROM RETURNED ' + this.rom_size.toString() + '.');
        }
    }
    startEmulator(preStartCallback) {
        let rom_r = this.mupen;
        let buf = preStartCallback();
        rom_r.romWriteBuffer(0x0, buf);
        let code = this.mupen.runEmulator(true);
        if (code > 0) {
            this.logger.error('MUPEN START RETURNED ' + code.toString() + '.');
        }
        return this.mupen;
    }
    stopEmulator() {
        this.mupen.stopEmulator();
    }
    finishInjects() {
        this.mupen.memoryCacheRefresh();
    }
    isEmulatorReady() {
        return this.mupen.coreEmuState() === 2;
    }
    getLoadedRom() {
        let rom_r = this.mupen;
        let buf = rom_r.romReadBuffer(0x0, this.rom_size);
        return buf;
    }
    setFrameCallback(fn) {
        this.mupen.setFrameCallback(fn);
    }
    hookFrameCallback() {
        this.mupen.hookFrameCallback();
    }
    pauseEmulator() {
        this.mupen.pauseEmulator();
    }
    resumeEmulator() {
        this.mupen.resumeEmulator();
    }
    getRomHeader() {
        let raw = this.mupen.romReadBuffer(0x0, 0x50);
        return new N64Header_1.N64Header(raw);
    }
    getMemoryAccess() {
        return this.mupen;
    }
    softReset() {
        this.mupen.softReset();
    }
    hardReset() {
        this.mupen.hardReset();
    }
    saveState(file) {
        this.mupen.saveState(file);
    }
    loadState(file) {
        this.mupen.loadState(file);
    }
}
exports.default = N64;
//# sourceMappingURL=N64.js.map