/// <reference types="node" />
import IMupen from './IMupen';
import IMemory from 'modloader64_api/IMemory';
import IConsole from 'modloader64_api/IConsole';
import { IRomHeader } from 'modloader64_api/IRomHeader';
import { ILogger } from 'modloader64_api/IModLoaderAPI';
declare class N64 implements IConsole {
    mupen: IMupen;
    rom_size: number;
    logger: ILogger;
    constructor(rom: string, logger: ILogger);
    startEmulator(preStartCallback: Function): IMemory;
    stopEmulator(): void;
    finishInjects(): void;
    isEmulatorReady(): boolean;
    getLoadedRom(): Buffer;
    setFrameCallback(fn: Function): void;
    hookFrameCallback(): void;
    pauseEmulator(): void;
    resumeEmulator(): void;
    getRomHeader(): IRomHeader;
    getMemoryAccess(): IMemory;
    softReset(): void;
    hardReset(): void;
    saveState(file: string): void;
    loadState(file: string): void;
}
export default N64;
