"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const bitwise_1 = __importDefault(require("bitwise"));
class FakeN64Memory {
    constructor() {
        this.buf = Buffer.alloc(0x800000);
    }
    rdramReadBitsBuffer(addr, bytes) {
        let buf = Buffer.alloc(bytes * 8);
        let buf_index = 0;
        let byte_index = 0;
        for (let i = 0; i < bytes; i++) {
            let data = this.buf.readUInt8(addr + byte_index);
            let bits = bitwise_1.default.byte.read(data);
            for (let j = 0; j < bits.length; j++) {
                buf.writeUInt8(bits[j], buf_index);
                buf_index++;
            }
            byte_index++;
        }
        return buf;
    }
    rdramReadBits8(addr) {
        let buf = Buffer.alloc(8);
        let data = this.buf.readUInt8(addr);
        let bits = bitwise_1.default.byte.read(data);
        for (let i = 0; i < bits.length; i++) {
            buf.writeUInt8(bits[i], i);
        }
        return buf;
    }
    rdramReadBit8(addr, bitoffset) {
        let data = this.buf.readUInt8(addr);
        let bits = bitwise_1.default.byte.read(data);
        return bits[bitoffset] === 1;
    }
    rdramWriteBitsBuffer(addr, buf) {
        let bytes = buf.byteLength / 8;
        for (let i = 0; i < bytes; i++) {
            let copy = Buffer.alloc(8);
            buf.copy(copy, 0, bytes * 8, bytes * 8 + 8);
            let data = this.buf.readUInt8(addr + i);
            let bits = bitwise_1.default.byte.read(data);
            for (let j = 0; j < copy.byteLength; j++) {
                bits[j] = copy.readUInt8(j);
            }
            data = bitwise_1.default.byte.write(bits);
            this.buf.writeUInt8(data, addr + i);
        }
    }
    rdramWriteBits8(addr, buf) {
        let data = this.buf.readUInt8(addr);
        let bits = bitwise_1.default.byte.read(data);
        for (let i = 0; i < buf.byteLength; i++) {
            bits[i] = buf.readUInt8(i);
        }
        data = bitwise_1.default.byte.write(bits);
        this.buf.writeUInt8(data, addr);
    }
    rdramWriteBit8(addr, bitoffset, bit) {
        let data = this.buf.readUInt8(addr);
        let bits = bitwise_1.default.byte.read(data);
        bits[bitoffset] = (bit ? 1 : 0);
        data = bitwise_1.default.byte.write(bits);
        this.buf.writeUInt8(data, addr);
    }
    rdramReadPtr8(addr, offset) {
        let pointer = this.dereferencePointer(addr);
        return this.rdramRead8(pointer + offset);
    }
    rdramWritePtr8(addr, offset, value) {
        let pointer = this.dereferencePointer(addr);
        this.rdramWrite8(pointer + offset, value);
    }
    rdramReadPtr16(addr, offset) {
        let pointer = this.dereferencePointer(addr);
        return this.rdramRead16(pointer + offset);
    }
    rdramWritePtr16(addr, offset, value) {
        let pointer = this.dereferencePointer(addr);
        this.rdramWrite16(pointer + offset, value);
    }
    rdramWritePtr32(addr, offset, value) {
        let pointer = this.dereferencePointer(addr);
        this.rdramWrite32(pointer + offset, value);
    }
    rdramReadPtr32(addr, offset) {
        let pointer = this.dereferencePointer(addr);
        return this.rdramRead32(pointer + offset);
    }
    rdramReadPtrBuffer(addr, offset, size) {
        let pointer = this.dereferencePointer(addr);
        return this.rdramReadBuffer(pointer + offset, size);
    }
    rdramWritePtrBuffer(addr, offset, buf) {
        let pointer = this.dereferencePointer(addr);
        this.rdramWriteBuffer(pointer + offset, buf);
    }
    rdramReadPtrS8(addr, offset) {
        let pointer = this.dereferencePointer(addr);
        return this.rdramReadS8(pointer + offset);
    }
    rdramReadPtrS16(addr, offset) {
        let pointer = this.dereferencePointer(addr);
        return this.rdramReadS16(pointer + offset);
    }
    rdramReadPtrS32(addr, offset) {
        let pointer = this.dereferencePointer(addr);
        return this.rdramReadS32(pointer + offset);
    }
    rdramReadPtrBitsBuffer(addr, offset, bytes) {
        let pointer = this.dereferencePointer(addr);
        return this.rdramReadBitsBuffer(pointer + offset, bytes);
    }
    rdramReadPtrBits8(addr, offset) {
        let pointer = this.dereferencePointer(addr);
        return this.rdramReadBits8(pointer + offset);
    }
    rdramReadPtrBit8(addr, offset, bitoffset) {
        let pointer = this.dereferencePointer(addr);
        return this.rdramReadBit8(pointer + offset, bitoffset);
    }
    rdramWritePtrBitsBuffer(addr, offset, buf) {
        let pointer = this.dereferencePointer(addr);
        this.rdramWriteBitsBuffer(pointer + offset, buf);
    }
    rdramWritePtrBits8(addr, offset, buf) {
        let pointer = this.dereferencePointer(addr);
        this.rdramWriteBits8(pointer + offset, buf);
    }
    rdramWritePtrBit8(addr, offset, bitoffset, bit) {
        let pointer = this.dereferencePointer(addr);
        this.rdramWriteBit8(pointer + offset, bitoffset, bit);
    }
    rdramRead8(addr) {
        return this.buf.readUInt8(addr);
    }
    rdramWrite8(addr, value) {
        this.buf.writeUInt8(value, addr);
    }
    rdramRead16(addr) {
        return this.buf.readUInt16BE(addr);
    }
    rdramWrite16(addr, value) {
        this.buf.writeUInt16BE(value, addr);
    }
    rdramWrite32(addr, value) {
        this.buf.writeUInt32BE(value, addr);
    }
    rdramRead32(addr) {
        return this.buf.readUInt32BE(addr);
    }
    rdramReadBuffer(addr, size) {
        let nb = Buffer.alloc(size);
        this.buf.copy(nb, 0, addr, addr + size);
        return nb;
    }
    rdramWriteBuffer(addr, buf) {
        buf.copy(this.buf, addr, 0, buf.byteLength);
    }
    rdramReadUBuffer(addr, size) {
        let nb = Buffer.alloc(size);
        this.buf.copy(nb, 0, addr, addr + size);
        return nb;
    }
    dereferencePointer(addr) {
        return this.rdramRead32(addr) - 0x80000000;
    }
    rdramReadS8(addr) {
        return this.buf.readUInt8(addr);
    }
    rdramReadS16(addr) {
        return this.buf.readUInt16BE(addr);
    }
    rdramReadS32(addr) {
        return this.buf.readUInt32BE(addr);
    }
}
exports.FakeN64Memory = FakeN64Memory;
//# sourceMappingURL=FakeN64Memory.js.map