"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const FakeN64Memory_1 = require("./FakeN64Memory");
const Rom_1 = require("../Rom");
const N64Header_1 = require("./N64Header");
class FakeMupen {
    constructor(rom) {
        this.rom = rom;
        this.rom_data = new Rom_1.Rom(this.rom).bytes;
        this.ram = new FakeN64Memory_1.FakeN64Memory();
    }
    startEmulator(preStartCallback) {
        preStartCallback(this.rom_data);
        return this.ram;
    }
    stopEmulator() { }
    finishInjects() { }
    isEmulatorReady() {
        return true;
    }
    getLoadedRom() {
        return this.rom_data;
    }
    setFrameCallback(fn) { }
    hookFrameCallback() { }
    pauseEmulator() { }
    resumeEmulator() { }
    getRomHeader() {
        let b = Buffer.alloc(0x50);
        this.rom_data.copy(b, 0, 0, 0x50);
        return new N64Header_1.N64Header(b);
    }
    getMemoryAccess() {
        return this.ram;
    }
    softReset() { }
    hardReset() { }
    saveState(file) { }
    loadState(file) { }
}
exports.FakeMupen = FakeMupen;
//# sourceMappingURL=FakeMupen.js.map