/// <reference types="node" />
import IConsole from 'modloader64_api/IConsole';
import { FakeN64Memory } from './FakeN64Memory';
import IMemory from 'modloader64_api/IMemory';
import { IRomHeader } from 'modloader64_api/IRomHeader';
export declare class FakeMupen implements IConsole {
    rom: string;
    rom_data: Buffer;
    ram: FakeN64Memory;
    constructor(rom: string);
    startEmulator(preStartCallback: Function): IMemory;
    stopEmulator(): void;
    finishInjects(): void;
    isEmulatorReady(): boolean;
    getLoadedRom(): Buffer;
    setFrameCallback(fn: Function): void;
    hookFrameCallback(): void;
    pauseEmulator(): void;
    resumeEmulator(): void;
    getRomHeader(): IRomHeader;
    getMemoryAccess(): IMemory;
    softReset(): void;
    hardReset(): void;
    saveState(file: string): void;
    loadState(file: string): void;
}
