"use strict";
// Modloader configuration
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = __importDefault(require("fs"));
class configuration {
    constructor(file) {
        this.data = {};
        this.file = file;
        if (fs_1.default.existsSync(file)) {
            this.data = JSON.parse(fs_1.default.readFileSync(file, 'utf8'));
        }
        else {
            fs_1.default.writeFileSync(file, JSON.stringify(this.data, null, 2));
        }
    }
    setData(category, key, value, override = false) {
        if (!this.data[category].hasOwnProperty(key) || override) {
            this.data[category][key] = value;
            this.save();
        }
    }
    registerConfigCategory(category) {
        if (!this.data.hasOwnProperty(category)) {
            this.data[category] = {};
            this.save();
        }
        return this.data[category];
    }
    save() {
        fs_1.default.writeFileSync(this.file, JSON.stringify(this.data, null, 2));
    }
}
exports.default = configuration;
//# sourceMappingURL=config.js.map