/// <reference types="node" />
/// <reference types="socket.io" />
import { ILogger, IConfig } from 'modloader64_api/IModLoaderAPI';
import { IPacketHeader, INetworkPlayer, LobbyData, ILobbyStorage, ILobbyManager } from 'modloader64_api/NetworkHandler';
import IModLoaderConfig from './IModLoaderConfig';
import { PluginMeta } from 'modloader64_api/LobbyVariable';
import dgram, { Socket } from 'dgram';
interface IServerConfig {
    port: number;
}
interface IClientConfig {
    ip: string;
    port: number;
    nickname: string;
    lobby: string;
    password: string;
}
declare class Version {
    major: number;
    minor: number;
    build: number;
    constructor(major: string, minor: string, build: string);
    match(v: Version): boolean;
}
declare class FakeNetworkPlayer implements INetworkPlayer {
    nickname: string;
    uuid: string;
    constructor();
    isSamePlayer(compare: INetworkPlayer): boolean;
}
declare namespace NetworkEngine {
    class Server implements ILobbyManager {
        io: any;
        encrypt: any;
        logger: ILogger;
        masterConfig: IConfig;
        config: IServerConfig;
        version: Version;
        modLoaderconfig: IModLoaderConfig;
        lobbyVariables: PluginMeta[];
        currently_processing_lobby: string;
        fakePlayer: FakeNetworkPlayer;
        udpServer: Socket;
        udpPort: number;
        constructor(logger: ILogger, config: IConfig);
        getLobbies(): any;
        doesLobbyExist(Lobby: string): any;
        createLobbyStorage(ld: LobbyData, owner: string): ILobbyStorage;
        getLobbyStorage(name: string): ILobbyStorage;
        sendToTarget(target: string, internalChannel: string, packet: any): void;
        setup(): void;
    }
    class Client {
        private io;
        socket: SocketIO.Socket;
        logger: ILogger;
        config: IClientConfig;
        modLoaderconfig: IModLoaderConfig;
        masterConfig: IConfig;
        me: INetworkPlayer;
        encrypt: any;
        udpClient: dgram.Socket;
        serverUDPPort: number;
        isUDPEnabled: boolean;
        udpTestHandle: any;
        packetBuffer: IPacketHeader[];
        constructor(logger: ILogger, config: IConfig);
        onTick(): void;
        setup(): void;
    }
}
export default NetworkEngine;
