"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const modloader64_1 = __importDefault(require("./modloader/modloader64"));
const winston_1 = __importDefault(require("winston"));
const commander_1 = __importDefault(require("commander"));
const path_1 = __importDefault(require("path"));
const JSON_1 = require("./monkeypatches/JSON");
require('fs-lock')({
    file_accessdir: [__dirname, process.cwd()],
    open_basedir: [__dirname, process.cwd()],
});
require('source-map-support').install();
const projectID = 'ModLoader64';
const authors = ['denoflions', 'SpiceyWolf'];
const testers = [];
const version = '1.0.0';
global.ModLoader = {};
global.ModLoader['version'] = version;
const logger = winston_1.default.createLogger({
    level: 'info',
    format: winston_1.default.format.combine(winston_1.default.format.splat(), winston_1.default.format.simple()),
    transports: [
        new winston_1.default.transports.File({ filename: 'error.log', level: 'error' }),
        new winston_1.default.transports.File({ filename: 'combined.log' }),
        new winston_1.default.transports.Console({
            format: winston_1.default.format.combine(winston_1.default.format.label({ label: 'index' }), winston_1.default.format.cli({ colors: { info: 'green' } }), winston_1.default.format.splat()),
        }),
    ],
});
logger.info(projectID);
logger.info('Authors: %s', authors);
if (testers.length > 0) {
    logger.info('Testers: %s', testers);
}
logger.info('Version: %s', version);
commander_1.default.option('-d, --dir <dir>', 'set directory');
commander_1.default.option('-dd, --dirforce <dir>', 'set directory');
commander_1.default.parse(process.argv);
if (commander_1.default.dir) {
    process.chdir(path_1.default.resolve(path_1.default.join(process.cwd(), commander_1.default.dir)));
    logger.info('Setting running directory: ' + process.cwd());
}
if (commander_1.default.dirforce) {
    process.chdir(commander_1.default.dirforce);
    logger.info('Setting running directory: ' + process.cwd());
}
// Monkey patches
let stringify = new JSON_1.MonkeyPatch_Stringify();
stringify.patch();
let parse = new JSON_1.MonkeyPatch_Parse();
parse.patch();
logger.info('Starting in CLI Mode...');
const instance = new modloader64_1.default(logger.child({}));
instance.start();
//# sourceMappingURL=index.js.map