"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const EventHandler_1 = require("./EventHandler");
function LobbyVariable(objectKey) {
    return function (target, key) {
        if (target.ModLoader === undefined) {
            target['ModLoader'] = {};
        }
        if (target.ModLoader.LobbyVariable === undefined) {
            target.ModLoader['LobbyVariable'] = new Map();
        }
        target.ModLoader.LobbyVariable.set(key, () => [objectKey, key]);
    };
}
exports.LobbyVariable = LobbyVariable;
class PluginMeta {
    constructor(instance, prototype, objectKey, fieldName, field) {
        this.instance = instance;
        this.prototype = prototype;
        this.fieldName = fieldName;
        this.objectKey = objectKey;
        this.template = JSON.stringify(field);
    }
    setField(data) {
        // @ts-ignore
        this.instance[this.fieldName] = data;
    }
    cloneTemplate() {
        return JSON.parse(this.template);
    }
}
exports.PluginMeta = PluginMeta;
function setupLobbyVariable(plugin) {
    let prototype = Object.getPrototypeOf(plugin);
    if (prototype.hasOwnProperty('ModLoader')) {
        if (prototype.ModLoader.hasOwnProperty('LobbyVariable')) {
            prototype.ModLoader.LobbyVariable.forEach(function (value, key) {
                let keys = value();
                // @ts-ignore
                let baseValue = plugin[keys[1]];
                let meta = new PluginMeta(plugin, prototype, keys[0], keys[1], baseValue);
                EventHandler_1.bus.emit('setupLobbyVariable', meta);
            });
        }
    }
}
exports.setupLobbyVariable = setupLobbyVariable;
//# sourceMappingURL=LobbyVariable.js.map