"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs = __importStar(require("fs"));
const path = __importStar(require("path"));
const PakFormat_1 = require("./PakFormat");
class GameShark {
    constructor(logger, emulator) {
        this.logger = logger;
        this.emulator = emulator;
    }
    read_gs(original) {
        let lines = original.split(/\r?\n/);
        let commands = {
            codes: [],
        };
        for (let i = 0; i < lines.length; i++) {
            if (lines[i].substr(0, 2) === '--') {
                continue;
            }
            let a = lines[i].substr(0, 2);
            let b = lines[i].substr(2, lines[i].length);
            let c = parseInt('0x' + b.split(' ')[0], 16);
            let d = parseInt('0x' + b.split(' ')[1], 16);
            commands.codes.push({ type: a, addr: c, payload: d });
        }
        for (let i = 0; i < commands.codes.length; i++) {
            if (commands.codes[i].type === '80') {
                this.emulator.rdramWrite8(commands.codes[i].addr, commands.codes[i].payload);
            }
            else if (commands.codes[i].type === '81') {
                this.emulator.rdramWrite16(commands.codes[i].addr, commands.codes[i].payload);
            }
        }
    }
    read(data) {
        let file = path.parse(data);
        switch (file.ext) {
            case '.payload': {
                this.logger.info('Parsing payload ' + file.base + '.');
                let original = fs.readFileSync(data, 'utf8');
                this.read_gs(original);
                break;
            }
            case '.pak': {
                this.logger.info('Loading pak ' + file.base + '.');
                let pak = new PakFormat_1.Pak(data);
                for (let i = 0; i < pak.pak.header.files.length; i++) {
                    let buf = pak.load(i);
                    let filename = pak.pak.header.files[i].filename;
                    let parse = path.parse(filename);
                    this.logger.info('- parsing pak data: ' + parse.base + '.');
                    if (parse.ext === '.payload') {
                        this.read_gs(buf.toString('ascii'));
                    }
                    else if (parse.ext === '.bin') {
                        this.emulator.rdramWriteBuffer(parseInt(parse.base), buf);
                    }
                }
            }
        }
    }
}
exports.GameShark = GameShark;
//# sourceMappingURL=GameShark.js.map