export declare const enum GameVersion {
    JP_1_0 = 0,
    PAL_1_0 = 1,
    USA_1_0 = 2,
    USA_1_1 = 3
}
export declare const enum AddressType {
    BETA_MENU = "BK:beta_menu",
    PLYR_ANIMAL = "BK:plyr_animal",
    PLYR_ANIMATION = "BK:plyr_animation",
    PLYR_FLIP_FACING = "BK:plyr_flip_facing",
    PLYR_MODEL_INDEX = "BK:plyr_model_index",
    PLYR_MODEL_PTR = "BK:plyr_model_ptr",
    PLYR_MOVEMENT_STATE = "BK:plyr_state",
    PLYR_OPACITY = "BK:plyr_opacity",
    PLYR_POS_X = "BK:plyr_pos_x",
    PLYR_POS_Y = "BK:plyr_pos_y",
    PLYR_POS_Z = "BK:plyr_pos_z",
    PLYR_ROT_X = "BK:plyr_rot_x",
    PLYR_ROT_Y = "BK:plyr_rot_y",
    PLYR_ROT_Z = "BK:plyr_rot_z",
    PLYR_SCALE = "BK:plyr_scale",
    PLYR_VISIBLE = "BK:plyr_visible",
    RT_ACTOR_ARRAY_PTR = "BK:rt_actor_arr_ptr",
    RT_COLLISION_PTR = "BK:rt_collision_ptr",
    RT_CUR_EXIT = "BK:rt_current_exit",
    RT_CUR_HEALTH = "BK:rt_current_health",
    RT_CUR_LEVEL = "BK:rt_current_level",
    RT_CUR_LEVEL_LOOKUP = "BK:rt_current_level_table",
    RT_CUR_LEVEL_JINJOS = "BK:rt_current_level_jinjos",
    RT_CUR_LEVEL_NOTES = "BK:rt_current_level_notes",
    RT_CUR_PROFILE = "BK:rt_current_profile",
    RT_CUR_SCENE = "BK:rt_current_scene",
    RT_CUR_SCENE_EVENTS = "BK:rt_current_scene_events",
    RT_IS_CUTSCENE = "BK:rt_is_cutscene",
    RT_IS_LOADING = "BK:rt_is_loading",
    RT_TRANSITION_STATE = "BK:rt_transition_state",
    RT_VOXEL_ARRAY_PTR = "BK:rt_voxel_arr_ptr",
    RT_VOXEL_COUNT_PTR = "BK:rt_voxel_cnt_ptr",
    RT_CUR_LEVEL_ACORN = "BK:rt_acorn",
    RT_CUR_LEVEL_CATERPILLAR = "BK:rt_caterpillar",
    RT_CUR_LEVEL_EVENTS = "BK:rt_current_level_events",
    RT_CUR_LEVEL_GOLD_BULLION = "BK:rt_gold_bullion",
    RT_CUR_LEVEL_PRESENT_GREEN = "BK:rt_present_green",
    RT_CUR_LEVEL_PRESENT_BLUE = "BK:rt_present_blue",
    RT_CUR_LEVEL_PRESENT_RED = "BK:rt_present_red",
    RT_CUR_LEVEL_ORANGE = "BK:rt_orange",
    SAVE_GAME_FLAGS = "BK:save_game_flags",
    SAVE_HONEYCOMB_FLAGS = "BK:save_honeycomb_flags",
    SAVE_JIGGY_FLAGS = "BK:save_jiggy_flags",
    SAVE_MOVE_FLAGS = "BK:save_move_flags",
    SAVE_MUMBO_TOKEN_FLAGS = "BK:save_mumbo_token_flags",
    SAVE_NOTE_TOTALS = "BK:save_note_totals",
    INV_HEALTH_UPGRADES = "BK:inv_health_upgrades",
    INV_HONEYCOMBS = "BK:inv_honeycombs",
    INV_JIGGIES = "BK:inv_jiggies",
    INV_MUMBO_TOKENS = "BK:inv_mumbo_tokens",
    INV_TEXT_JIGGIES = "BK:inv_text_jiggies",
    INV_TEXT_MUMBO_TOKENS = "BK:inv_text_mumbo_tokens",
    INV_EGGS = "BK:inv_eggs",
    INV_RED_FEATHERS = "BK:inv_red_feather",
    INV_GOLD_FEATHERS = "BK:inv_gold_feather",
    INV_SCORE_TWINKLIE = "BK:inv_score_twinklie",
    INV_HOURGLASS_2 = "BK:inv_hourglass_2",
    INV_HOURGLASS_SKULL = "BK:inv_hourglass_skull",
    INV_HOURGLASS_TIMER = "BK:inv_hourglass_timer",
    INV_TIMER_XMAS_TREE = "BK:inv_timer_xmas_tree",
    INV_TIMER_PROPELLOR = "BK:inv_timer_propellor"
}
export declare enum AnimationType {
    UNKNOWN = 0,
    BANJO_DUCKING = 1,
    BANJO_WALKING_SLOW = 2,
    BANJO_WALKING = 3,
    BANJO_PUNCHING = 5,
    BANJO_TALON_TROT_END = 7,
    BANJO_JUMPING = 8,
    BANJO_DYING = 9,
    BANJO_CLIMBING = 10,
    BANJO_RUNNING = 12,
    BANJO_SKIDDING = 14,
    BANJO_HURT = 15,
    BIGBUTT_CHARGING = 16,
    BANJO_WONDERWING_RUNNING = 17,
    BANJO_TALON_TROT_WALKING = 21,
    BANJO_TALON_TROT_START = 22,
    BANJO_FLUTTER = 23,
    BANJO_FEATHERY_FLAP = 24,
    BANJO_RATATAT_RAP = 25,
    BANJO_RATATAT_RAP_START = 26,
    BANJO_WONDERWING_JUMPING = 27,
    BANJO_BEAK_BARGE = 28,
    BANJO_BEAK_BUSTER = 29,
    BIGBUTT_SKIDDING = 33,
    BANJO_WONDERWING_START = 34,
    BANJO_WONDERWING = 35,
    YUMYUM_HOPPING = 36,
    BANJO_TALON_TROT = 38,
    BANJO_TALON_TROT_JUMPING = 39,
    TERMITE_HURT = 40,
    TERMITE_DYING = 41,
    BANJO_SHOOTING_EGG = 42,
    BANJO_POOPING_EGG = 43,
    SNIPPET_WALKING = 44,
    JINJO_IDLE = 45,
    BANJO_JIGGY_JIG = 46,
    JINJO_HELP = 47,
    HELD_JIGGY_JIGGY_JIG = 48,
    JINJO_HOPPING = 49,
    BIGBUTT_ATTACKING = 50,
    BIGBUTT_EATING = 51,
    BIGBUTT_DYING = 52,
    BIGBUTT_ALERTED = 53,
    BIGBUTT_WALKING = 54,
    BANJO_FLYING = 56,
    BANJO_SWIMMING_SURFACE = 57,
    BANJO_DIVING = 60,
    BANJO_SHOCK_SPRING_JUMP_1 = 61,
    BANJO_FLYING_CRASH = 62,
    BANJO_SWIMMING_UNDERWATER_B = 63,
    BANJO_WADING_BOOTS_START = 64,
    BANJO_WADING_BOOTS = 65,
    BANJO_WADING_BOOTS_WALKING = 66,
    BANJO_BEAKBOMB_START = 67,
    BANJO_TURBO_TALON_TRAINERS = 68,
    BANJO_FLYING_START = 69,
    BANJO_BEAKBOMB = 71,
    BANJO_SHOCK_SPRING_JUMP_START = 72,
    BANJO_SHOCK_SPRING_JUMP_2 = 73,
    BANJO_FLAP_FLIP = 75,
    BANJO_FLAP_FLIP_TRANSISTION = 76,
    BANJO_HURT_2 = 77,
    MM_MUDHUT_SMASHING = 78,
    BANJO_WATER_SPLASH = 79,
    CONGA_IDLE = 81,
    CONGA_HURT = 82,
    CONGA_DEFEATED = 83,
    CONGA_THROWING = 84,
    CONGA_BEATING_CHEST = 85,
    CONGA_RAISING_ARMS = 86,
    BANJO_SWIMMING_UNDERWATER = 87,
    BANJO_SWIMMING_UNDERWATER_A = 88,
    BANJO_SLIDING_BACK = 89,
    BANJO_SLIDING_FRONT = 90,
    CHIMPY_HOPPING = 91,
    CHIMPY_IDLE = 92,
    CHIMPY_WALKING = 93,
    TICKER_IDLE = 94,
    TICKER_WALKING = 95,
    TERMITE_JUMPING = 96,
    BANJO_FLAP_FLIP_END = 97,
    GRUBLIN_IDLE = 98,
    GRUBLIN_WALKING = 99,
    GRUBLIN_JUMPING = 100,
    BEEHIVE_DYING = 101,
    BANJO_TALON_TROT_HURT = 102,
    WADING_BOOTS_IDLE = 103,
    BANJO_FALLING = 104,
    BANJO_ON_TUMBLAR = 105,
    MUMBO_SLEEPING = 106,
    MUMBO_WALKING = 107,
    MUMBO_IDLE = 108,
    MUMBO_TRANSFORMING = 109,
    MUMBO_UNKNOWN_6E = 110,
    BANJO_IDLE = 111,
    BANJO_SWIMMING_UNDERWATER_2 = 112,
    BANJO_SWIMMING_SLOW = 113,
    BANJO_CARRYING_ITEM = 114,
    BANJO_CARRYING_ITEM_WALKING = 115,
    BANJO_LOSING_MINIGAME = 119,
    SNACKER_SWIMMING = 120,
    CS_CONCERT_MUMBO_PLAYING = 121,
    CS_CONCERT_BANJO_ANGRY = 122,
    CS_CONCERT_BANJO_PLAYING = 123,
    CS_CONCERT_BANJO_END = 124,
    CS_CONCERT_TOOTY_START = 125,
    CS_CONCERT_BANJO_START = 126,
    CS_CONCERT_CUTSCENE = 127,
    CS_CONCERT_TIMER = 128,
    CS_CONCERT_UNKNOWN_0x81 = 129,
    CS_CONCERT_MUMBO_DANCING = 130,
    CS_CONCERT_TOOTY_DANCING = 131,
    TOOTY_HOPPING = 132,
    RAREWARE_LOGO_FALLING = 140,
    NINTENDO_CUBE_WALKING = 143,
    NINTENDO_CUBE_SHRUGGING = 144,
    CS_CONCERT_FROG_HOPPING = 145,
    SHRAPNEL_CHASING = 146,
    TOOTY_RUNNING = 147,
    GRUBLIN_DYING = 148,
    BANJO_IDLE_KAZOOIE_TAUNT = 149,
    SNIPPET_RECOVERING = 150,
    SNIPPET_DYING = 151,
    RIPPER_IDLE = 154,
    RIPPER_CHASING = 155,
    NIBBLY_CHASING = 157,
    TEEHEE_IDLE = 158,
    TEEHEE_ALERTED = 159,
    PUMPKIN_WALKING = 160,
    PUMPKIN_JUMPING = 161,
    CONGA_THROWING_2 = 162,
    NAPPER_SLEEPING = 163,
    NAPPER_LOOKING_AROUND = 164,
    NAPPER_WALKING = 165,
    NAPPER_ALERTED = 166,
    MOTZHAND_IDLE = 167,
    MOTZHAND_PLAYING = 168,
    POT = 169,
    YUMYUM_IDLE = 170,
    YUMYUM_EATING = 171,
    TEEHEE_CHASING = 172,
    NIBBLY_FLYING_START = 173,
    NIBBLY_IDLE = 174,
    BANJO_FALLING_2 = 176,
    BANJO_CLIMBING_2 = 177,
    BANJO_CLIMBING_FREEZE = 178,
    CHOMPA_IDLE = 179,
    CHOMPA_ATTACKING = 180,
    BLUBBER_WALKING = 181,
    BLUBBER_CRYING = 182,
    BLUBBER_DANCING = 183,
    BLUBBER_RUNNING = 184,
    BANJO_DROWNING = 185,
    LOCKUP_IDLE = 188,
    NIPPER_VULNERABLE = 189,
    NIPPER_HURT = 190,
    NIPPER_ATTACKING = 191,
    NIPPER_IDLE = 192,
    CLANKER_IDLE = 195,
    CLANKER_MOUTH_OPEN = 196,
    GRABBA_APPEARING = 197,
    GRABBA_HIDING = 198,
    GRABBA_IDLE = 199,
    GRABBA_DEFEATED = 200,
    MAGIC_CARPET = 201,
    GLOOP_SWIMMING = 202,
    GLOOP_BLOWING_BUBBLE = 203,
    BANJO_BEAKBOMB_END = 204,
    RUBEE_IDLE = 206,
    HISTUP_RAISED = 207,
    HISTUP_RAISING = 208,
    HISTUP_IN_POT = 209,
    BANJO_GETTING_UP = 210,
    BANJO_BEAKBOMB_HURT = 211,
    SWITCH_DOWN = 212,
    SWITCH_UP = 213,
    TURBO_TALON_TRAINERS_IDLE = 214,
    GOBI_IDLE = 217,
    GOBI_PULLING_ON_CHAIN = 218,
    FLIBBIT_HOPPING = 219,
    GOBIS_ROPE_PULLING = 220,
    GOBIS_ROPE_IDLE = 221,
    RUBEE_PETTING_TOOTS = 223,
    CROC_WALKING = 224,
    CROC_IDLE = 225,
    HISTUP_PEEKING = 226,
    RUBEE_IDLE_2 = 227,
    RUBEE_PLAYING = 228,
    GRABBA_SHADOW_SPAWNING = 229,
    GRABBA_SHADOW_IDLE = 230,
    GRABBA_SHADOW_HIDING = 231,
    GRABBA_SHADOW_DEFEATED = 232,
    SLAPPA_APPEARING = 233,
    SLAPPA_MOVING = 234,
    SLAPPA_SLAPPING = 235,
    SLAPPA_GETTING_UP = 236,
    ANCIENT_ONE_ENTER_EXIT = 237,
    SLAPPA_DYING = 238,
    SLAPPA_HURT = 239,
    MINIJINXY_EATING = 240,
    MAGIC_CARPET_2 = 241,
    GOBI_RELAXING = 244,
    BANJO_IDLE_PULLING_KAZOOIE = 246,
    GOBI_HAPPY = 247,
    GOBI_RUNNING = 248,
    BUZZBOMB_FLYING = 249,
    FLIBBIT_IDLE = 250,
    FLIBBIT_TURNING = 251,
    GOBI_GIVING_WATER = 252,
    GOBI_GETTING_UP = 253,
    TRUNKER_SHORT = 254,
    TRUNKER_GROWING = 255,
    TANKTUP_HEAD_IDLE = 257,
    TANKTUP_HEAD_POUNDED = 258,
    TANKTUP_LEG_BACK_LEFT_HIT = 259,
    TANKTUP_LEG_FRONT_LEFT_HIT = 260,
    TANKTUP_LEG_FRONT_RIGHT_HIT = 261,
    TANKTUP_LEG_BACK_RIGHT_HIT = 262,
    TANKTUP_SPAWNING_JIGGY = 263,
    SIR_SLUSH_IDLE = 264,
    SIR_SLUSH_ATTACKING = 265,
    BANJO_DUCKING_TURNING = 268,
    BANJO_FLYING_HIT = 269,
    BUZZBOMB_PREPARING_CHARGE = 270,
    BUZZBOMB_CHARGING = 271,
    BUZZBOMB_FALLING = 272,
    BUZZBOMB_DYING = 273,
    FLIBBIT_DYING_START = 274,
    FLIBBIT_DYING_END = 275,
    BANJO_DUCKING_LOOKING = 278,
    BANJO_CARRYING_ITEM_THROWING = 283,
    CROC_JUMPING = 284,
    CROC_HURT = 285,
    CROC_DYING = 286,
    WALRUS_IDLE = 287,
    WALRUS_WALKING = 288,
    WALRUS_JUMPING = 289,
    CROC_BITING = 290,
    CROC_EAT_WRONG_THING = 291,
    MR_VILE_EATING = 292,
    YUMBLIE_APPEARING = 293,
    YUMBLIE_LEAVING = 294,
    YUMBLIE_IDLE = 295,
    GRUMBLIE_APPEARING = 296,
    GRUMBLIE_LEAVING = 297,
    GRUMBLIE_IDLE = 298,
    TIPTUP_LOOKING_AROUND_SHRUGGING = 299,
    TIPTUP_TAPPING = 300,
    TIPTUP_CHOIR_MEMBER_IDLE = 301,
    TIPTUP_CHOIR_MEMBER_SINGING = 302,
    TIPTUP_CHOIR_MEMBER_HURT = 303,
    JINJO_CIRCLING_START = 304,
    JINJO_CIRCLING_END = 305,
    FLOATSAM_BOUNCING = 306,
    NIPPER_DYING = 307,
    GRIMLET_ATTACKING = 311,
    TEXT_BACKDROP_APPEARING = 312,
    BOTTLES_DISAPPEARING = 313,
    BOTTLES_APPEARING = 314,
    BOTTLES_SCRATCHING = 315,
    BOTTLES_MOLEHILL_IDLE_1 = 316,
    BOTTLES_MOLEHILL_IDLE_2 = 317,
    SNORKEL_SWIMMING = 318,
    SNORKEL_STUCK = 319,
    RBB_ANCHOR_IDLE = 321,
    RBB_ANCHOR_RISING = 322,
    BUTTON = 323,
    JINXY_SNIFFING = 324,
    JINXY_SNEEZING = 325,
    BOSS_BOOMBOX_APPEARING = 326,
    BOOMBOX_HOPPING = 327,
    BOOMBOX_EXPLODING = 328,
    BANJO_FALL_DAMAGE = 329,
    BANJO_LISTENING = 330,
    CROCTUS_IDLE = 331,
    BOGGY_IDLE = 332,
    BOGGY_HIT = 333,
    BOGGY_LAYING_DOWN = 334,
    BOGGY_RUNNING = 335,
    BOGGY_ON_SLED_IDLE = 336,
    RACE_FLAG_HIT = 337,
    RACE_FLAG_IDLE = 338,
    GOLD_CHEST_SPAWNING = 339,
    SNACKER_EATING = 340,
    SNIPPET_GET_UP = 341,
    MUTIE_SNIPPET_WALKING = 342,
    MUTIE_SNIPPET_UPSIDEDOWN_START = 343,
    MUTIE_SNIPPET_UPSIDEDOWN = 344,
    MUTIE_SNIPPET_UPSIDEDOWN_END = 345,
    GRILLE_CHOMPA_ATTACKING = 346,
    GRILLE_CHOMPA_DYING = 347,
    WHIPLASH_IDLE = 348,
    WHIPLASH_ATTACKING = 349,
    CS_CONCERT_BANJO_OFF_SCREEN = 351,
    CS_CONCERT_BUG_CRAWLING = 352,
    TOOTS_IDLE = 354,
    CS_CONCERT_BUZZBOMB_HITTING_LOGO = 355,
    BEEHIVE_IDLE = 357,
    GOLD_CHEST_BOUNCING = 358,
    SNAREBEAR_SNAPPING = 363,
    SNAREBEAR_IDLE = 364,
    TWINKLY_BOX_OPENING = 365,
    MUMBO_RECLINING = 366,
    ZUBBA_FLYING = 367,
    ZUBBA_IDLE = 368,
    ZUBBA_FALLING = 369,
    ZUBBA_LANDING = 370,
    FLOWER_SPRING_GROWING = 371,
    FLOWER_SUMMER_GROWING = 372,
    FLOWER_AUTUMN_GROWING = 373,
    GOBI_YAWNING = 374,
    GOBI_SLEEPING = 375,
    TWINKLY_APPEARING = 376,
    BOGGY_ON_SLED_TAUNTING = 377,
    BOGGY_ON_SLED_LOOKING_BACK = 378,
    TWINKLY_TWINKLING = 380,
    BOOGYS_CHILDREN_HAPPY = 381,
    BOOGYS_CHILDREN_SAD = 382,
    MUMBO_SWEEPING = 383,
    MUMBO_ROTATION = 384,
    FLOWER_SPRING_IDLE = 385,
    FLOWER_SUMMER_IDLE = 386,
    FLOWER_AUTUMN_IDLE = 387,
    BIG_CLUCKER_ATTACKING_SHORT = 388,
    BIG_CLUCKER_ATTACKING_LONG = 389,
    BIG_CLUCKER_DYING = 390,
    PUMPKIN_DYING = 392,
    FLOATSAM_DYING = 393,
    FP_PRESENT_IDLE = 394,
    EYRIE_SPRING_FALLING_ASLEEP = 399,
    EYRIE_SPRING_SLEEPING = 400,
    EYRIE_SUMMER_IDLE = 401,
    EYRIE_SUMMER_GROWING = 402,
    EYRIE_SUMMER_FALLING_ASLEEP = 403,
    EYRIE_SUMMER_SLEEPING = 404,
    EYRIE_AUTUMN_IDLE = 405,
    EYRIE_AUTUMN_GROWING = 406,
    EYRIE_AUTUMN_FALLING_ASLEEP = 407,
    EYRIE_AUTUMN_SLEEPING = 408,
    EYRIE_WINTER_IDLE = 409,
    EYRIE_WINTER_FLYING = 410,
    BANJO_TRANSFORMING = 411,
    WALRUS_HURT = 412,
    WALRUS_DYING = 413,
    WALRUS_ON_SLED = 414,
    WALRUS_LOST_RACE_START = 415,
    SLED_IDLE = 417,
    NABNUT_SLEEPING = 418,
    NABNUT_IDLE = 419,
    NABNUT_EATING = 420,
    GNAWTY_IDLE = 422,
    GNAWTY_HAPPY = 423,
    GNAWTY_WALKING = 424,
    WALRUS_LOST_RACE = 425,
    BOGGY_WON_RACE = 426,
    BOGGY_LOST_RACE = 427,
    WOZZA_WITH_JIGGY_IDLE = 428,
    WOZZA_THROWING_JIGGY = 429,
    WOZZA_WALKING = 430,
    TWINKLY_MUNCHER_DYING = 431,
    TWINKLY_MUNCHER_APPEARING = 432,
    TWINKLY_MUNCHER_IDLE = 433,
    TWINKLY_MUNCHER_MUNCHING = 434,
    WOZZA_BEFORE_STOP = 435,
    WOZZA_SCARED = 436,
    WOZZA_GIVING_JIGGY = 437,
    WOZZA_HALF_THROW_FREEZE = 438,
    CS_INTRO_GREEN_MIST_IDLE = 439,
    CS_INTRO_DOOR_OPENING = 440,
    CS_INTRO_GRUNTY_IDLE = 441,
    CS_INTRO_GRUNTY_PICKING_NOSE = 443,
    CS_INTRO_GRUNTY_ANGRY_AT_DINGPOT = 445,
    CS_INTRO_GRUNTY_THROWING_BOOGER = 446,
    CS_INTRO_GRUNTY_SHOCKED_CONFUSED = 447,
    CS_INTRO_GRUNTY_WALKING = 448,
    CS_INTRO_DOOR_CLOSING = 450,
    CS_INTRO_GRUNTYS_BROOM_FLYING = 452,
    GRUNTY_FLYING = 453,
    CS_INTRO_BANJO_SLEEPING = 455,
    CS_INTRO_BANJO_WAKING_UP = 456,
    CS_INTRO_BEDSHEETS_BANJO_SLEEPING = 457,
    CS_INTRO_BEDSHEETS_BANJO_AWAKE = 458,
    CS_INTRO_KAZOOIE_ON_COAT_RACK_APPEARING = 459,
    CS_INTRO_KAZOOIE_ON_COAT_RACK_IDLE = 461,
    CS_INTRO_CURTAIN = 462,
    CS_INTRO_KAZOOIE_ON_COAT_RACK_UNEASY = 463,
    TOOTY_IDLE = 464,
    CS_INTRO_KAZOOIE_ON_COAT_RACK_WAKING_BANJO = 467,
    CS_INTRO_KAZOOIE_ON_COAT_RACK_FALLING = 468,
    TOOTY_SCARE = 469,
    GRUBLIN_WALKING_2 = 470,
    GRUBLIN_ALERTED = 471,
    GRUBLIN_CHASING = 472,
    GRUBLIN_DYING_2 = 473,
    SNIPPET_IDLE = 474,
    MUTIE_SNIPPET_IDLE = 475,
    BEE_FLYING = 476,
    BEE_WALKING = 477,
    BEE_IDLE = 478,
    BEE_UNKNOWN_0X1DF = 479,
    BEE_HURT = 480,
    BEE_DYING = 481,
    BEE_JUMPING = 482,
    GV_BRICK_WALL_SMASHING = 483,
    LIMBO_IDLE = 484,
    LIMBO_ALERTED = 485,
    LIMBO_CHASING = 486,
    LIMBO_BREAKING = 487,
    LIMBO_RECOVERING = 488,
    MUMMUM_IDLE = 489,
    MUMMUM_CURLING = 490,
    MUMMMUM_UNCURLING = 491,
    RIPPER_HURT = 493,
    RIPPER_DYING = 494,
    SHRAPNEL_IDLE = 500,
    SEXY_GRUNTY_WALKING = 506,
    SEXY_GRUNTY_CHECKING_SELF_OUT = 507,
    UGLY_TOOTY_WALKING = 508,
    UGLY_TOOTY_PUNCHING = 509,
    KLUNGO_WALKING = 513,
    KLUNGO_PUSHING_BUTTON = 514,
    GRUNTY_FALLING = 516,
    ROYSTEN_IDLE = 520,
    CUCKOO_CLOCK_IDLE = 521,
    CUCKOO_CLOCK_CHIMING = 522,
    KLUNGO_PULLING_LEVER = 525,
    KLUNGO_LAUGHING = 527,
    WARP_CAULDRON_ACTIVATING = 530,
    WARP_CAULDRON_SLEEPING = 531,
    WARP_CAULDRON_IDLE = 532,
    WARP_CAULDRON_TELEPORTING = 533,
    WARP_CAULDRON_REJECTING = 534,
    EYRIE_SUMMER_EATING = 538,
    EYRIE_AUTUMN_EATING = 539,
    EYRIE_FLYING = 541,
    EYRIE_WINTER_POOPING_JIGGY = 542,
    TOPPER_IDLE = 547,
    TOPPER_DYING = 548,
    NABNUT_FAT = 555,
    NABNUT_CRYING = 556,
    NABNUT_HAPPY = 557,
    NABNUT_IDLE_2 = 558,
    NABNUT_RUNNING = 559,
    MRS_NABNUT_SLEEPING = 560,
    NABNUTS_BEDSHEETS = 561,
    PUMPKIN_HURT = 566,
    LOGGO_IDLE = 568,
    LOGGO_FLUSHING = 576,
    GRUBLIN_HOOD_IDLE = 579,
    GRUBLIN_HOOD_ALERTED = 580,
    GRUBLIN_HOOD_CHASING = 581,
    GRUBLIN_HOOD_DYING = 582,
    FS_BANJO_COOKING_IDLE = 586,
    FS_BANJO_COOKING_SELECTED = 587,
    FS_BANJO_COOKING_SPIN = 588,
    FS_BANJO_SLEEPING_IDLE = 589,
    FS_BANJO_SLEEPING_SELECTED = 590,
    FS_BANJO_SLEEPING_SPRING = 591,
    FS_BANJO_PLAYING_GAMEBOY_IDLE = 592,
    FS_BANJO_PLAYING_GAMEBOY_THUMBSUP = 593,
    FS_BANJO_PLAYING_GAMEBOY_SPRING = 594,
    BIGBUTT_HURT = 595,
    BIGBUTT_DEFEATED_START = 596,
    BIGBUTT_RECOVERING = 597,
    ACORN_IDLE = 603,
    JINJO_STATUE_RISING = 610,
    JINJO_STATUE_ACTIVATING = 612,
    JINJO_STATUE_IDLE = 613,
    BRENTILDA_IDLE = 619,
    BRENTILDA_HANDS_ON_HIPS = 620,
    GRUNTLING_IDLE = 621,
    GRUNTLING_ALERTED = 622,
    GRUNTLING_CHASING = 623,
    GRUNTLING_DYING = 624,
    CHEATO_IDLE = 626,
    SNACKER_HURT = 627,
    SNACKER_DYING = 628,
    FLIBBIT_HURT = 648,
    GNAWTY_SWIMMING = 649,
    FF_WASHING_MACHINE = 650,
    GRUNTY_DOLL = 652
}
export declare enum JinjoType {
    BLUE = 0,
    GREEN = 1,
    ORANGE = 2,
    PINK = 3,
    YELLOW = 4
}
export declare enum ActorType {
    BIGBUTT = 4,
    TICKER = 5,
    GRUBLIN = 6,
    MUMBO_0X0007 = 7,
    MM_CONGA = 8,
    MM_HUT = 9,
    FISH = 10,
    SHOCK_SPRING_PAD = 11,
    MUD_HUT = 12,
    WOOD_DEMOLISHED = 13,
    BULL_2 = 14,
    MM_CHIMPY = 15,
    MM_JU_JU_HITBOX = 17,
    BEEHIVE = 18,
    MM_CONGA_ORANGE = 20,
    SHADOW = 23,
    LEAKY = 30,
    OYSTER = 36,
    MMM_CEMETARY_POT = 37,
    CLIMBABLE_POLE = 38,
    MM_COLLECTABLE_ORANGE = 41,
    TTC_GOLD_BULLION = 42,
    TURBO_TRAINERS = 44,
    MUMBO_TOKEN = 45,
    PHANTOM = 57,
    MMM_MOTZAND = 58,
    BIG_KEY = 60,
    RBB_PROPELLER_1 = 61,
    RBB_PROPELLER_2 = 62,
    RBB_PROPELLER_3 = 63,
    RBB_PROPELLER_4 = 64,
    RBB_PROPELLER_5 = 65,
    RBB_PROPELLER_6 = 66,
    SCREW = 67,
    ROCK = 68,
    UNKNOWN_0X0045 = 69,
    JIGGY = 70,
    EMPTY_HONEYCOMB_PIECE = 71,
    EXTRA_LIFE = 73,
    WOOD_EXPLOSION = 74,
    EXPLOSION_2 = 75,
    STEAM = 76,
    STEAM_2 = 77,
    SPARKLES = 78,
    SPARKLES_2 = 79,
    HONEYCOMB = 80,
    MUSIC_NOTE = 81,
    EGG = 82,
    TTC_RED_ARROW = 83,
    TTC_RED_QUESTION_MARK = 84,
    TTC_RED_X = 85,
    EXPLOSION = 86,
    MM_ORANGE_PAD = 87,
    MM_JUJU_TOTEM_POLE = 89,
    JIGGY_IN_HAND = 90,
    EGG_1 = 91,
    COLLECTABLE_JINJO_YELLOW = 94,
    COLLECTABLE_JINJO_ORANGE = 95,
    COLLECTABLE_JINJO_BLUE = 96,
    COLLECTABLE_JINJO_PINK = 97,
    COLLECTABLE_JINJO_GREEN = 98,
    WATER_LEVEL_SWITCH = 100,
    WADING_BOOTS = 101,
    UNKNOWN_0X0066 = 102,
    TTC_SNIPPET = 103,
    SNACKER = 104,
    TTC_YUMYUM = 105,
    UNKNOWN_0X006C = 108,
    BANJO_DOOR = 109,
    CS_CONCERT_BK = 142,
    CS_CONCERT_MUMBO = 143,
    YELLOW_JINJO_1 = 144,
    YELLOW_JINJO_2 = 145,
    CS_CONCERT_TOOIE = 146,
    CS_NINTENDO_CUBE = 147,
    CS_RAREWARE_LOGO = 148,
    YELLOW_JINJO_3 = 149,
    YELLOW_JINJO_4 = 150,
    YELLOW_JINJO_5 = 151,
    YELLOW_JINJO_6 = 152,
    UNKNOWN_0X0099 = 153,
    UNKNOWN_0X009A = 154,
    CS_CONCERT_BULL = 155,
    CS_CONCERT_FROG = 156,
    GRUNTY_1 = 158,
    YELLOW_JINJO_7 = 159,
    UNKNOWN_0X00A1 = 161,
    YELLOW_JINJO_8 = 163,
    UNKNOWN_0X00A4 = 164,
    CS_CONCERT_BUZZBOMB = 165,
    BGS_YUMBLIE = 166,
    CS_BBQ_MUMBO = 167,
    CS_BBQ_1 = 168,
    CS_BBQ_2 = 169,
    CS_INTRO_DINGPOT_1 = 170,
    CS_INTRO_GRUNTY_ARMS = 171,
    GRUNTY_2 = 172,
    CS_INTRO_NIBBLY = 173,
    CS_INTRO_DINGPOT_2 = 174,
    CS_INTRO_GREEN_MIST = 175,
    CS_INTRO_BOTTLES = 176,
    CS_INTRO_BOTTLES_MOLEHILL = 177,
    CS_INTRO_MACHINE_ROOM_DOOR = 178,
    CS_INTRO_TOOTY = 180,
    CS_INTRO_GRUNTYS_BROOMSTICK = 181,
    CS_INTRO_GRUNTY_ON_BROOMSTICK = 182,
    YELLOW_JINJO_9 = 183,
    CS_INTRO_BANJO_SLEEPING = 184,
    CS_INTRO_BED = 185,
    YELLOW_JINJO_10 = 186,
    CS_INTRO_KAZOOIE_ON_COAT_RACK = 187,
    CS_INTRO_BANJOS_CURTAINS = 188,
    CS_INTRO_CURTAINS_PURPLE_CHECKERED = 188,
    CS_INTRO_BANJOS_DOOR = 189,
    YELLOW_JINJO_11 = 190,
    YELLOW_JINJO_12 = 191,
    CS_GAMEOVER_SEXY_GRUNTY = 194,
    CS_GAMEOVER_UGLY_TOOTY = 195,
    MMM_RIPPER = 199,
    MMM_TEEHEE = 202,
    CC_GLOOP = 230,
    BGS_TANKTUP = 232,
    BGS_TANKTUP_HEAD = 233,
    BGS_TANKTUP_LEG_1 = 234,
    BGS_TANKTUP_LEG_2 = 235,
    BGS_TANKTUP_LEG_3 = 236,
    EGG_2 = 238,
    EGG_3 = 239,
    EGG_4 = 240,
    TTC_BLACK_SNIPPET = 242,
    CC_MUTIE_SNIPPET = 245,
    MMM_CELLAR_DOOR = 267,
    MMM_CHURCH_DOOR = 276,
    TTC_BLUBBER = 277,
    TTC_NIPPER_SHELL = 279,
    GV_MAGIC_CARPET_1 = 281,
    GV_RUBEE = 283,
    GV_HISTUP = 284,
    GV_MAGIC_CARPET_2 = 291,
    GV_GOBI_1 = 302,
    GV_GOBI_2 = 305,
    GV_TRUNKER = 306,
    GV_GOBI_3 = 309,
    BGS_FLIBBET_YELLOW = 311,
    BGS_MR_VILE = 314,
    RBB_FLOATSAM = 315,
    GV_SUN_SWITCH = 319,
    GV_SUN_DOOR = 320,
    GV_STAR_HATCH = 322,
    GV_KAZOOIE_DOOR = 323,
    GV_STAR_SWITCH = 324,
    GV_HONEYCOMB_SWITCH = 325,
    GV_KAZOOIE_TARGET = 326,
    GV_ANCIENT_ONE = 327,
    BGS_GREEN_JIGGY_SWITCH = 334,
    BGS_DESTROYED_JIGGY = 335,
    FP_CHRISTMAS_TREE = 351,
    SM_COLIWOBBLE = 356,
    SM_TOPPER = 358,
    CCW_WINTER_SWITCH = 360,
    CCW_AUTUMN_SWITCH = 362,
    CCW_SUMMER_SWITCH = 364,
    SM_QUARRY = 367,
    FILE_SELECT_BANJO_PLAYING_GAMEBOY = 406,
    FILE_SELECT_BANJO_COOKING = 407,
    FILE_SELECT_BANJOS_BED = 408,
    FILE_SELECT_BANJOS_CHAIR = 409,
    FILE_SELECT_BANJOS_KITCHEN = 410,
    RBB_SNORKEL = 456,
    RBB_ANCHOR_AND_CHAIN = 457,
    RBB_RAREWARE_FLAG_POLE = 458,
    LAIR_CHEATO_1 = 469,
    LAIR_CHEATO_2 = 470,
    LAIR_CHEATO_3 = 471,
    FP_MOGGY = 490,
    FP_SOGGY = 491,
    FP_GROGGY = 492,
    FP_COLLECTABLE_PRESENT_BLUE = 493,
    FP_COLLECTABLE_PRESENT_GREEN = 495,
    FP_COLLECTABLE_PRESENT_RED = 497,
    FP_WOZZA_OUTSIDE = 499,
    BGS_CROCTUS = 506,
    MM_WITCH_SWITCH = 516,
    MMM_WITCH_SWITCH = 518,
    TTC_WITCH_SWITCH = 520,
    RBB_WITCH_SWITCH = 523,
    CCW_WITCH_SWITCH = 567,
    FP_WITCH_SWITCH = 569,
    CC_WITCH_SWITCH = 603,
    SNS_ICE_KEY = 605,
    SNS_EGG = 606,
    BGS_TIPTUP = 634
}
export declare enum AnimalType {
    UNKNOWN = 0,
    BEAR_BIRD = 1,
    TERMITE = 2,
    PUMPKIN = 3,
    WALRUS = 4,
    CROCODILE = 5,
    BEE = 6,
    WASHING_MACHINE = 7
}
export declare enum ExitType {
    UNKNOWN = 0,
    MM_MAIN_MUMBOS_SKULL = 1,
    MM_MAIN_TICKERS_TOWER_BOTTOM = 2,
    MM_MAIN_TICKERS_TOPER_TOP = 3,
    MM_MAIN_BUTTON_CUTSCENE = 4,
    MM_MAIN_LEVEL_ENTRANCE = 5,
    TTC_MAIN_SANDCASTLE = 3,
    TTC_MAIN_LEVEL_ENTRANCE = 4,
    TTC_BLUBBERS_SHIP_TOP = 5,
    TTC_BLUBBERS_SHIP_BOTTOM = 6,
    TTC_MAIN_BLUBBERS_SHIP_TOP = 6,
    TTC_MAIN_BLUBBERS_SHIP_SIDE = 7,
    TTC_MAIN_LIGHTHOUSE_TOP = 8,
    TTC_MAIN_NIPPER = 10,
    TTC_LIGHTHOUSE_BOTTOM = 12,
    TTC_STAIR_ALCOVE_TOP = 14,
    TTC_STAIR_ALCOVE_BOTTOM = 15,
    SM_MAIN_BANJOS_HOUSE = 18,
    SM_MAIN_GRUNTILDAS_LAIR = 19
}
export declare enum LevelType {
    UNKNOWN = 0,
    MUMBOS_MOUNTAIN = 1,
    TREASURE_TROVE_COVE = 2,
    CLANKERS_CAVERN = 3,
    BUBBLE_GLOOP_SWAMP = 4,
    FREEZEEZY_PEAK = 5,
    GRUNTILDAS_LAIR = 6,
    GOBEYS_VALEY = 7,
    CLICK_CLOCK_WOODS = 8,
    RUSTY_BUCKET_BAY = 9,
    MAD_MONSTER_MANSION = 10,
    SPIRAL_MOUNTAIN = 11,
    GRUNTILDAS_LAIR_ROOF = 12,
    TITLE_SCREEN = 13
}
export declare enum MoveType {
    BEAK_BARGE = 0,
    BEAK_BOMB = 1,
    BEAK_BUSTER = 1,
    CAMERA_CONTROLS = 3,
    BEAR_PUNCH = 4,
    CLIMB_POLES = 5,
    EGGS = 6,
    FEATHERY_FLAP = 7,
    FLIP_FLAP = 8,
    FLYING = 9,
    VARIABLE_JUMP_HEIGHT = 10,
    RAT_A_TAT_RAP = 11,
    ROLL = 12,
    SHOCK_SPRING_JUMP = 13,
    WADDING_BOOTS = 14,
    DIVE = 15,
    TALON_TROT = 16,
    TURBO_TALON_TRAINERS = 17,
    WONDERWING = 18,
    NOTE_DOOR_MOLE_HILL = 19
}
export declare enum ProfileType {
    Title = -1,
    A = 0,
    B = 2,
    C = 1
}
export declare enum SceneType {
    UNKNOWN = 0,
    SM_MAIN = 1,
    MM_MAIN = 2,
    UNKNOWN_0X03 = 3,
    UNKNOWN_0x04 = 4,
    TTC_BLUBBERS_SHIP = 5,
    TTC_NIPPERS_SHELL = 6,
    TTC_MAIN = 7,
    UNKNOWN_0X08 = 8,
    UNKNOWN_0x09 = 9,
    TTC_SANDCASTLE = 10,
    CC_CLANKERS_CAVERN = 11,
    MM_TICKERS_TOWER = 12,
    BGS_MAIN = 13,
    MM_MUMBOS_SKULL = 14,
    UNKNOWN_0X0F = 15,
    BGS_MR_VILE = 16,
    BGS_TIPTUP = 17,
    GV_MAIN = 18,
    GV_MATCHING_GAME = 19,
    GV_MAZE = 20,
    GV_WATER = 21,
    GV_RUBEES_CHAMBER = 22,
    UNKNOWN_0X17 = 23,
    UNKNOWN_0X18 = 24,
    UNKNOWN_0X19 = 25,
    GV_SPHINX = 26,
    MMM_MAIN = 27,
    MMM_CHURCH_1 = 28,
    MMM_CELLAR = 29,
    START_NINTENDO = 30,
    START_RAREWARE = 31,
    END_SCENE_2_ = 32,
    CC_WITCH_SWITCH = 33,
    CC_INSIDE_CLANKER = 34,
    CC_GOLD_FEATHER = 35,
    MMM_TIMBLAR_SHED = 36,
    MMM_WELL = 37,
    MMM_DINING_ROOM_NAPPER = 38,
    FP_MAIN = 39,
    MMM_ROOM_1 = 40,
    MMM_ROOM_2 = 41,
    MMM_FIREPLACE = 42,
    MMM_CHURCH_2 = 43,
    MMM_BATHROOM = 44,
    MMM_BEDROOM = 45,
    MMM_FLOORBOARDS = 46,
    MMM_BARREL = 47,
    MMM_MUMBOS_SKULL = 48,
    RBB_MAIN = 49,
    UNKNOWN_0X32 = 50,
    UNKNOWN_0X33 = 51,
    RBB_ENGINE_ROOM = 52,
    RBB_WAREHOUSE_1 = 53,
    RBB_WAREHOUSE_2 = 54,
    RBB_CONTAINER_1 = 55,
    RBB_CONTAINER_3 = 56,
    RBB_CREW_CABIN = 57,
    RBB_BOSS_BOOM_BOX = 58,
    RBB_STORE_ROOM = 59,
    RBB_KITCHEN = 60,
    RBB_NAVIGATION_ROOM = 61,
    RBB_CONTAINER_2 = 62,
    RBB_CAPTAINS_CABIN = 63,
    CCW_MAIN = 64,
    FP_BOGGYS_IGLOO = 65,
    UNKNOWN_0X42 = 66,
    CCW_SPRING = 67,
    CCW_SUMMER = 68,
    CCW_AUTUMN = 69,
    CCW_WINTER = 70,
    BGS_MUMBOS_SKULL = 71,
    FP_MUMBOS_SKULL = 72,
    UNKNOWN_0X49 = 73,
    CCW_SPRING_MUMBOS_SKULL = 74,
    CCW_SUMMER_MUMBOS_SKULL = 75,
    CCW_AUTUMN_MUMBOS_SKULL = 76,
    CCW_WINTER_MUMBOS_SKULL = 77,
    UNKNOWN_0X4E = 78,
    UNKNOWN_0X4F = 79,
    UNKNOWN_0X50 = 80,
    UNKNOWN_0X51 = 81,
    UNKNOWN_0X52 = 82,
    FP_INSIDE_XMAS_TREE = 83,
    UNKNOWN_0X54 = 84,
    UNKNOWN_0X55 = 85,
    UNKNOWN_0X56 = 86,
    UNKNOWN_0X57 = 87,
    UNKNOWN_0X58 = 88,
    UNKNOWN_0X59 = 89,
    CCW_SUMMER_ZUBBAS_HIVE = 90,
    CCW_SPRING_ZUBBAS_HIVE = 91,
    CCW_AUTUMN_ZUBBAS_HIVE = 92,
    UNKNOWN_0X5D = 93,
    CCW_SPRING_NABNUTS_HOUSE = 94,
    CCW_SUMMER_NABNUTS_HOUSE = 95,
    CCW_AUTUMN_NABNUTS_HOUSE = 96,
    CCW_WINTER_NABNUTS_HOUSE = 97,
    CCW_WINTER_NABNUTS_1 = 98,
    CCW_AUTUMN_NABNUTS_2 = 99,
    CCW_WINTER_NABNUTS_2 = 100,
    CCW_SPRING_TOP = 101,
    CCW_SUMMER_TOP = 102,
    CCW_AUTUMN_TOP = 103,
    CCW_WINTER_TOP = 104,
    GL_LOBBY_MM = 105,
    GL_PUZZLE_TTC = 106,
    GL_PUZZLE_CC = 106,
    GL_NOTE_DOOR_180 = 107,
    GL_PUZZLE_CCW = 107,
    GL_RED_CAULDRON = 108,
    GL_LOBBY_TTC = 109,
    GL_LOBBY_GV = 110,
    GL_LOBBY_FP = 111,
    GL_LOBBY_CC = 112,
    GL_WITCH_STATUE = 113,
    GL_LOBBY_BGS = 114,
    UNKNOWN_0X73 = 115,
    GL_PUZZLE_GV = 116,
    GL_LOBBY_MMM = 117,
    GL_NOTE_DOOR_640 = 118,
    GL_LOBBY_RBB = 119,
    GL_PUZZLE_RBB = 120,
    GL_LOBBY_CCW = 121,
    GL_FLOOR_2_CRYPT_INSIDE = 122,
    INTRO_LAIR_1 = 123,
    INTRO_BANJO_HOUSE_1 = 124,
    INTRO_SPIRAL_A = 125,
    INTRO_SPIRAL_B = 126,
    FP_WOZZAS_CAVE = 127,
    GL_FLOOR_3 = 128,
    INTRO_LAIR_2 = 129,
    INTRO_MACHINE_1 = 130,
    INTRO_GAME_OVER = 131,
    INTRO_LAIR_5 = 132,
    INTRO_SPIRAL_C = 133,
    INTRO_SPIRAL_D = 134,
    INTRO_SPIRAL_E = 135,
    INTRO_SPIRAL_F = 136,
    INTRO_BANJO_HOUSE_2 = 137,
    INTRO_BANJO_HOUSE_3 = 138,
    RBB_ANCHOR = 139,
    SM_BANJO_HOUSE = 140,
    MMM_INSIDE_LOGGO = 141,
    GL_FURNACE_FUN = 142,
    TTC_SHARKFOOD_ISLAND = 143,
    GL_BATTLEMENTS = 144,
    FILE_SELECT = 145,
    GV_SECRET_CHAMBER = 146,
    GL_DINGPOT = 147,
    INTRO_SPIRAL_G = 148,
    END_SCENE_3 = 149,
    END_SCENE_1 = 150,
    END_SCENE_4 = 151,
    INTRO_GRUNTY_THREAT_1 = 152,
    INTRO_GRUNTY_THREAT_2 = 153
}
