/// <reference types="node" />
import bits from './bits';
import buffer from './buffer';
import byte from './byte';
import integer from './integer';
import nibble from './nibble';
import string from './string';
export { bits, buffer, byte, integer, nibble, string };
declare const bitwise: {
    bits: {
        and: (bits1: import("./types").Bit[], bits2: import("./types").Bit[]) => import("./types").Bit[];
        nand: (bits1: import("./types").Bit[], bits2: import("./types").Bit[]) => import("./types").Bit[];
        nor: (bits1: import("./types").Bit[], bits2: import("./types").Bit[]) => import("./types").Bit[];
        not: (bits: import("./types").Bit[]) => import("./types").Bit[];
        or: (bits1: import("./types").Bit[], bits2: import("./types").Bit[]) => import("./types").Bit[];
        reduceAnd: (bits: import("./types").Bit[]) => import("./types").Bit;
        reduceNand: (bits: import("./types").Bit[]) => import("./types").Bit;
        reduceNor: (bits: import("./types").Bit[]) => import("./types").Bit;
        reduceOr: (bits: import("./types").Bit[]) => import("./types").Bit;
        reduceXnor: (bits: import("./types").Bit[]) => import("./types").Bit;
        reduceXor: (bits: import("./types").Bit[]) => import("./types").Bit;
        toBoolean: (bits: import("./types").Bit[]) => boolean[];
        toString: (bits: import("./types").Bit[], spacing?: number, spacer?: string) => string;
        xnor: (bits1: import("./types").Bit[], bits2: import("./types").Bit[]) => import("./types").Bit[];
        xor: (bits1: import("./types").Bit[], bits2: import("./types").Bit[]) => import("./types").Bit[];
    };
    buffer: {
        and: (a: Buffer, b: Buffer, isLooping?: boolean) => Buffer;
        create: (bits: import("./types").Bit[]) => Buffer;
        modify: (buffer: Buffer, bits: import("./types").Bit[], offset?: number) => void;
        nand: (a: Buffer, b: Buffer, isLooping?: boolean) => Buffer;
        nor: (a: Buffer, b: Buffer, isLooping?: boolean) => Buffer;
        not: (buffer: Buffer) => Buffer;
        or: (a: Buffer, b: Buffer, isLooping?: boolean) => Buffer;
        read: (buffer: Buffer, offset?: number, length?: number | undefined) => import("./types").Bit[];
        readInt: (buffer: Buffer, offset?: number, length?: number) => number;
        readUInt: (buffer: Buffer, offset?: number, length?: number) => number;
        xnor: (a: Buffer, b: Buffer, isLooping?: boolean) => Buffer;
        xor: (a: Buffer, b: Buffer, isLooping?: boolean) => Buffer;
    };
    byte: {
        read: (byte: import("./types").UInt8) => [import("./types").Bit, import("./types").Bit, import("./types").Bit, import("./types").Bit, import("./types").Bit, import("./types").Bit, import("./types").Bit, import("./types").Bit];
        write: (byte: [import("./types").Bit, import("./types").Bit, import("./types").Bit, import("./types").Bit, import("./types").Bit, import("./types").Bit, import("./types").Bit, import("./types").Bit]) => import("./types").UInt8;
    };
    integer: {
        getBit: (int32: number, position: number) => import("./types").Bit;
        setBit: (int32: number, position: number, value: import("./types").Bit) => import("./types").Bit;
        toggleBit: (int32: number, position: number) => number;
    };
    nibble: {
        read: (nibble: import("./types").UInt4) => [import("./types").Bit, import("./types").Bit, import("./types").Bit, import("./types").Bit];
        write: (nibble: [import("./types").Bit, import("./types").Bit, import("./types").Bit, import("./types").Bit]) => import("./types").UInt4;
    };
    string: {
        toBits: (string: string) => import("./types").Bit[];
    };
};
export default bitwise;
