"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const commander_1 = __importDefault(require("commander"));
const path_1 = __importDefault(require("path"));
const fs_1 = __importDefault(require("fs"));
const PakFormat_1 = require("./PakFormat");
commander_1.default.option('-i, --input <file>', 'input file');
commander_1.default.option('-o, --output <file>', 'output file');
commander_1.default.option('-b, --base <addr>', 'base address');
commander_1.default.option('-d --dir <dir>', 'base directory');
commander_1.default.parse(process.argv);
function hexPadding(i) {
    return ('0000' + i.toString(16)).substr(-4).toUpperCase();
}
function hexPadding2(i) {
    return ('00' + i.toString(16)).substr(-2).toUpperCase();
}
if (commander_1.default.input !== undefined) {
    let input = path_1.default.resolve(commander_1.default.input);
    let output = path_1.default.resolve(commander_1.default.output);
    let base = parseInt(commander_1.default.base);
    generatePayload(input, output, base);
}
if (commander_1.default.dir !== undefined) {
    let output = path_1.default.resolve(path_1.default.join(commander_1.default.dir, 'output' + '.pak'));
    let pak = new PakFormat_1.Pak(output);
    fs_1.default.readdirSync(path_1.default.resolve(commander_1.default.dir)).forEach((key) => {
        let parse = path_1.default.parse(key);
        if (parse.ext !== '.pak') {
            let input = path_1.default.join(commander_1.default.dir, key);
            pak.save_file(input);
            pak.update();
        }
    });
}
function generatePayload(inputfile, outputfile, base) {
    let data = fs_1.default.readFileSync(inputfile);
    console.log('Generating payload...');
    let codes = new Array();
    for (let i = 0; i < data.byteLength; i++) {
        codes.push('80' + (base + i).toString(16).toUpperCase() + ' ' + hexPadding(data[i]));
    }
    // TODO: Make this actually smart and mix 80 and 81 codes.
    if (codes.length % 2 === 0) {
        console.log('Optimizing payload...');
        codes.splice(0, codes.length);
        for (let i = 0; i < data.byteLength; i += 2) {
            codes.push('81' +
                (base + i).toString(16).toUpperCase() +
                ' ' +
                hexPadding2(data[i]) +
                hexPadding2(data[i + 1]));
        }
    }
    let result = '';
    for (let i = 0; i < codes.length; i++) {
        result += codes[i] + '\n';
    }
    result = result.trim();
    fs_1.default.writeFileSync(outputfile, result);
}
//# sourceMappingURL=pc.js.map