"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const commander_1 = __importDefault(require("commander"));
const fs_1 = __importDefault(require("fs"));
const PakFormat_1 = require("./PakFormat");
const sign_1 = require("./sign");
commander_1.default.option('-d --dir <dir>', 'base directory');
commander_1.default.option('-o, --output <file>', 'output file');
commander_1.default.parse(process.argv);
if (commander_1.default.dir !== undefined) {
    let recursive = require('recursive-readdir');
    require('mkdir-recursive');
    recursive(commander_1.default.dir, function (err, files) {
        let pak = new PakFormat_1.Pak(commander_1.default.dir + '.pak');
        for (let i = 0; i < files.length; i++) {
            pak.save_file(files[i]);
        }
        pak.update();
        if (fs_1.default.existsSync('./private_key.pem')) {
            fs_1.default.writeFileSync(commander_1.default.dir + '.sig', sign_1.generate(pak.fileName));
        }
    });
}
//# sourceMappingURL=paker.js.map