﻿using HarmonyLib;
using System.Reflection;
using static Progression;

namespace Harmony
{
    public class XpControl : IModApi
    {

        public void InitMod(Mod _modInstance)
        {
            Log.Out(" Loading Patch: " + GetType());
            var harmony = new HarmonyLib.Harmony(GetType().ToString());
            harmony.PatchAll(Assembly.GetExecutingAssembly());
        }
    }

    public class WorldStorage
    {
        public static World world;
    }

    [HarmonyPatch(typeof(World))]
    [HarmonyPatch("LoadWorld")]
    public class World_LoadWorld_Postfix
    {

        public static void Postfix(World __instance) {
            WorldStorage.world = __instance;
        }

    }

    [HarmonyPatch(typeof(World))]
    [HarmonyPatch("UnloadWorld")]
    public class World_UnloadWorld_Postfix
    {

        public static void Postfix(World __instance)
        {
            WorldStorage.world = null;
        }

    }

    [HarmonyPatch(typeof(World))]
    [HarmonyPatch("OnUpdateTick")]
    public class World_OnUpdateTick_Prefix
    {

        private static int counter = 0;
        private static int _max = 200;

        public static void Prefix(World __instance)
        {
            if (SingletonMonoBehaviour<ConnectionManager>.Instance.IsServer) return;
            counter++;
            if (counter < _max) return;
            var players = __instance.GetPlayers();
            int max = 0;
            for (int i = 0; i < players.Count; i++)
            {
                if (max < players[i].Progression.Level)
                {
                    max = players[i].Progression.Level;
                }
            }
            if (max > 0)
            {
                for (int i = 0; i < players.Count; i++)
                {
                    if (players[i].isEntityRemote) continue;
                    if (players[i].Progression.Level >= max) continue;
                    if (players[i].Progression.ExpDeficit > 0) continue;
                    Log.Out($"Leveling {players[i].EntityName} to {players[i].Progression.Level + 1}");
                    players[i].Progression.AddLevelExp(players[i].Progression.GetExpForNextLevel(), "_xpOther", Progression.XPTypes.Debug, false);
                    GameManager.ShowTooltip((EntityPlayerLocal)players[i], "Shared Level +1");
                    players[i].Progression.bProgressionStatsChanged = true;
                    players[i].bPlayerStatsChanged = true;
                }
            }
            counter = 0;
        }

    }

    [HarmonyPatch(typeof(Progression))]
    [HarmonyPatch("AddLevelExp")]
    public class Progression_AddLevelExp_Prefix
    {
        public static void Prefix(World __instance, int _exp, string _cvarXPName, XPTypes _xpType, bool useBonus)
        {
            if (_xpType != XPTypes.Debug && WorldStorage.world != null)
            {
                var players = WorldStorage.world.GetPlayers();
                int num = players.Count - 1;
                if (num <= 0) num = 1;
                _exp = (int)((double)_exp * (1.0 - 0.10000000149011612 * (double)num));
            }
        }
    }
}