﻿using HarmonyLib;
using System;
using System.Collections.Generic;
using System.IO;
using System.Reflection;

namespace Harmony
{
    public class DynamicBloodMoons : IModApi
    {

        public static DynamicBloodMoonsConfig config = new DynamicBloodMoonsConfig();

        public void InitMod(Mod _modInstance)
        {
            Log.Out(" Loading Patch: " + GetType());

            var harmony = new HarmonyLib.Harmony(GetType().ToString());
            harmony.PatchAll(Assembly.GetExecutingAssembly());

            if (!File.Exists("./DynamicBloodMoons.json"))
            {
                File.WriteAllText("./DynamicBloodMoons.json", SimpleJson2.SimpleJson2.SerializeObject(config));
            }
            config = (DynamicBloodMoonsConfig)SimpleJson2.SimpleJson2.DeserializeObject(File.ReadAllText("./DynamicBloodMoons.json"), config.GetType());
        }
    }

    public class DynamicBloodMoonsConfig
    {
        public int freeDays = 0;
    }

    [HarmonyPatch(typeof(AIDirectorBloodMoonComponent))]
    [HarmonyPatch("CalcNextDay")]
    public class AIDirectorBloodMoonComponent_CalcNextDay_Patch
    {

        public static void setDay(AIDirectorBloodMoonComponent __instance, int day) {
            Type type = __instance.GetType();
            MethodInfo info = type.GetMethod("SetDay", BindingFlags.NonPublic | BindingFlags.Instance);
            object[] parametersArray = new object[] { day };
            info.Invoke(__instance, parametersArray);
        }

        public static int getBloodMoonRange()
        {
            return GamePrefs.GetInt(EnumGamePrefs.BloodMoonRange);
        }

        public static int getCurrentDay(AIDirectorBloodMoonComponent __instance)
        {
            return GameUtils.WorldTimeToDays(__instance.Director.World.worldTime);
        }

        public static int getBloodMoodFreq()
        {
            return GamePrefs.GetInt(EnumGamePrefs.BloodMoonFrequency);
        }

        public static int getLastDay(AIDirectorBloodMoonComponent __instance) {
            return getCurrentDay(__instance) - 1;
        }

        public static List<EntityPlayer> getPlayers(AIDirectorBloodMoonComponent __instance)
        {
            Type type = __instance.GetType();
            FieldInfo info = type.GetField("players", BindingFlags.NonPublic | BindingFlags.Instance);
            return (List<EntityPlayer>)info.GetValue(__instance);
        }

        public static int RoundToTen(int n) {
            return Math.Abs(n) - Math.Abs(n) % 10;
        }

        private static void Postfix(AIDirectorBloodMoonComponent __instance)
        {
            List<EntityPlayer> players = getPlayers(__instance);
            if (players.Count == 0)
            {
                return;
            }
            Log.Out("[DynamicBloodMoons]: Hijacking next bloodmoon calculation...");
            int day = getLastDay(__instance);
            if (DynamicBloodMoons.config.freeDays > day)
            {
                Log.Out("[DynamicBloodMoons]: Stopping due to freeDays setting.");
                return;
            }
            Log.Out($"[DynamicBloodMoons]: {day} was the last horde day.");
            int range = getBloodMoonRange();
            int freq = getBloodMoodFreq();
            Log.Out($"[DynamicBloodMoons]: {freq} is the frequency.");
            int next = day + freq;
            if (range > 0)
            {
                Log.Out($"[DynamicBloodMoons]: {range} is the range.");
                int rng = __instance.Random.RandomRange(0, range + 1);
                next += rng;
            }
            int totalLevel = 0;
            for (int i = 0; i < players.Count; i++)
            {
                totalLevel += players[i].Progression.GetLevel();
            }
            int averageLevel = RoundToTen(totalLevel / players.Count) / 10;
            Log.Out($"[DynamicBloodMoons]: {averageLevel} is the current level modifier.");
            next -= averageLevel;
            if (next <= day)
            {
                next = day + 1;
            }
            Log.Out($"[DynamicBloodMoons]: day {next} will be the next bloodmoon.");
            setDay(__instance, next);
        }
    }
}